/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.LibraryFile;
import fxlauncher.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Application")
public class FXManifest {
    @XmlAttribute
    public Long ts;
    @XmlAttribute
    public URI uri;
    @XmlAttribute(name="launch")
    public String launchClass;
    @XmlElement(name="lib")
    public List<LibraryFile> files = new ArrayList<LibraryFile>();
    @XmlElement
    public String updateText = "Updating...";
    @XmlElement
    public String updateLabelStyle = "-fx-font-weight: bold;";
    @XmlElement
    public String progressBarStyle = "-fx-pref-width: 200;";
    @XmlElement
    public String wrapperStyle = "-fx-spacing: 10; -fx-padding: 25;";
    @XmlElement
    public String parameters;
    @XmlElement
    public String cacheDir;
    @XmlElement
    public Boolean acceptDowngrade = false;
    @XmlElement
    public Boolean stopOnUpdateErrors = false;
    @XmlElement
    public String preloadNativeLibraries;
    @XmlElement
    public String whatsNewPage;
    @XmlElement
    public Boolean lingeringUpdateScreen = false;

    public List<String> getPreloadNativeLibraryList() {
        if (this.preloadNativeLibraries == null || this.preloadNativeLibraries.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.preloadNativeLibraries.split(".*,-*"));
    }

    public String getFilename() {
        return String.format("%s.xml", this.launchClass);
    }

    public URI getFXAppURI() {
        if (this.uri.getPath().endsWith("/")) {
            return this.uri.resolve("app.xml");
        }
        return URI.create(this.uri.toString() + "/app.xml");
    }

    public Path getPath(Path cacheDir) {
        return cacheDir.resolve(this.getFilename());
    }

    public Path resolveCacheDir(Map<String, String> namedParams) {
        Path path;
        String cacheDir;
        if (namedParams == null) {
            namedParams = Collections.emptyMap();
        }
        String string = cacheDir = namedParams.containsKey("cache-dir") ? namedParams.get("cache-dir") : this.cacheDir;
        if (cacheDir == null || cacheDir.isEmpty()) {
            return Paths.get(".", new String[0]);
        }
        if (cacheDir.contains("USERLIB")) {
            String replacement;
            switch (OS.current) {
                case mac: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library").resolve("Application Support").resolve(cacheDir.substring(8)).toString();
                    break;
                }
                case win: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("AppData").resolve("Local").resolve(cacheDir.substring(8)).toString();
                    break;
                }
                default: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("." + cacheDir.substring(8)).toString();
                }
            }
            path = Paths.get(replacement, new String[0]);
        } else if (cacheDir.startsWith("ALLUSERS")) {
            switch (OS.current) {
                case mac: {
                    path = Paths.get("/Library/Application Support", new String[0]).resolve(cacheDir.substring(9));
                    break;
                }
                case win: {
                    path = Paths.get(System.getenv("ALLUSERSPROFILE"), new String[0]).resolve(cacheDir.substring(9));
                    break;
                }
                default: {
                    path = Paths.get("/usr/local/share", new String[0]).resolve(cacheDir.substring(9));
                    break;
                }
            }
        } else {
            path = Paths.get(cacheDir, new String[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return path;
    }

    public String getWhatsNewPage() {
        return this.whatsNewPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FXManifest that = (FXManifest)o;
        if (this.ts != null ? !this.ts.equals(that.ts) : that.ts != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.launchClass != null ? !this.launchClass.equals(that.launchClass) : that.launchClass != null) {
            return false;
        }
        if (this.files != null ? !this.files.equals(that.files) : that.files != null) {
            return false;
        }
        if (this.updateText != null ? !this.updateText.equals(that.updateText) : that.updateText != null) {
            return false;
        }
        if (this.updateLabelStyle != null ? !this.updateLabelStyle.equals(that.updateLabelStyle) : that.updateLabelStyle != null) {
            return false;
        }
        if (this.progressBarStyle != null ? !this.progressBarStyle.equals(that.progressBarStyle) : that.progressBarStyle != null) {
            return false;
        }
        if (this.wrapperStyle != null ? !this.wrapperStyle.equals(that.wrapperStyle) : that.wrapperStyle != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(that.cacheDir) : that.cacheDir != null) {
            return false;
        }
        if (this.lingeringUpdateScreen != null ? !this.lingeringUpdateScreen.equals(that.lingeringUpdateScreen) : that.lingeringUpdateScreen != null) {
            return false;
        }
        if (this.stopOnUpdateErrors != null ? !this.stopOnUpdateErrors.equals(that.stopOnUpdateErrors) : that.stopOnUpdateErrors != null) {
            return false;
        }
        return this.acceptDowngrade != null ? this.acceptDowngrade.equals(that.acceptDowngrade) : that.acceptDowngrade == null;
    }

    public int hashCode() {
        int result = this.ts != null ? this.ts.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.launchClass != null ? this.launchClass.hashCode() : 0);
        result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
        result = 31 * result + (this.updateText != null ? this.updateText.hashCode() : 0);
        result = 31 * result + (this.updateLabelStyle != null ? this.updateLabelStyle.hashCode() : 0);
        result = 31 * result + (this.progressBarStyle != null ? this.progressBarStyle.hashCode() : 0);
        result = 31 * result + (this.wrapperStyle != null ? this.wrapperStyle.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        result = 31 * result + (this.acceptDowngrade != null ? this.acceptDowngrade.hashCode() : 0);
        result = 31 * result + (this.stopOnUpdateErrors != null ? this.stopOnUpdateErrors.hashCode() : 0);
        return result;
    }

    public boolean isNewerThan(FXManifest other) {
        return this.ts == null || other.ts == null || this.ts > other.ts;
    }

    static FXManifest load(URI uri) throws IOException {
        if (Objects.equals(uri.getScheme(), "file")) {
            return (FXManifest)JAXB.unmarshal((File)new File(uri.getPath()), FXManifest.class);
        }
        URLConnection connection = uri.toURL().openConnection();
        if (uri.getUserInfo() != null) {
            byte[] payload = uri.getUserInfo().getBytes(StandardCharsets.UTF_8);
            String encoded = Base64.getEncoder().encodeToString(payload);
            connection.setRequestProperty("Authorization", String.format("Basic %s", encoded));
        }
        try (InputStream input = connection.getInputStream();){
            FXManifest fXManifest = (FXManifest)JAXB.unmarshal((InputStream)input, FXManifest.class);
            return fXManifest;
        }
    }
}

