/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.FXManifest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Application;

public class LauncherParams
extends Application.Parameters {
    private final List<String> rawArgs = new ArrayList<String>();
    private final Map<String, String> namedParams = new HashMap<String, String>();
    private final List<String> unnamedParams = new ArrayList<String>();

    public LauncherParams(List<String> rawArgs) {
        this.rawArgs.addAll(rawArgs);
        this.computeParams();
    }

    public LauncherParams(Application.Parameters delegate, FXManifest manifest) {
        this.rawArgs.addAll(delegate.getRaw());
        if (manifest.parameters != null) {
            for (String arg : manifest.parameters.split("\\s")) {
                if (arg == null || this.rawArgs.contains(arg)) continue;
                if (arg.startsWith("--") && arg.contains("=")) {
                    String argname = arg.substring(0, arg.indexOf("="));
                    if (this.rawArgs.stream().filter(a -> a.startsWith(argname)).findAny().isPresent()) continue;
                }
                this.rawArgs.add(arg);
            }
        }
        this.computeParams();
    }

    private void computeParams() {
        this.computeNamedParams();
        this.computeUnnamedParams();
    }

    public List<String> getRaw() {
        return this.rawArgs;
    }

    public List<String> getUnnamed() {
        return this.unnamedParams;
    }

    public Map<String, String> getNamed() {
        return this.namedParams;
    }

    private boolean isNamedParam(String arg) {
        return arg.startsWith("--") && arg.indexOf(61) > 2 && this.validFirstChar(arg.charAt(2));
    }

    private void computeNamedParams() {
        this.rawArgs.stream().filter(this::isNamedParam).forEach(arg -> {
            int eqIdx = arg.indexOf(61);
            String key = arg.substring(2, eqIdx);
            String value = arg.substring(eqIdx + 1);
            this.namedParams.put(key, value);
        });
    }

    private void computeUnnamedParams() {
        this.unnamedParams.addAll(this.rawArgs.stream().filter(arg -> !this.isNamedParam((String)arg)).collect(Collectors.toList()));
    }

    private boolean validFirstChar(char c) {
        return Character.isLetter(c) || c == '_';
    }
}

