/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.config.builders.StateMachineTransitionBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.security.SecurityRule;

public abstract class AbstractTransitionConfigurer<S, E>
extends AnnotationConfigurerAdapter<TransitionsData<S, E>, StateMachineTransitionConfigurer<S, E>, StateMachineTransitionBuilder<S, E>> {
    private S source;
    private S target;
    private S state;
    private E event;
    private Long period;
    private Integer count;
    private final Collection<Action<S, E>> actions = new ArrayList<Action<S, E>>();
    private Guard<S, E> guard;
    private SecurityRule securityRule;

    protected S getSource() {
        return this.source;
    }

    protected S getTarget() {
        return this.target;
    }

    protected S getState() {
        return this.state;
    }

    protected E getEvent() {
        return this.event;
    }

    protected Long getPeriod() {
        return this.period;
    }

    public Integer getCount() {
        return this.count;
    }

    protected Collection<Action<S, E>> getActions() {
        return this.actions;
    }

    protected Guard<S, E> getGuard() {
        return this.guard;
    }

    protected SecurityRule getSecurityRule() {
        return this.securityRule;
    }

    protected void setSource(S source) {
        this.source = source;
    }

    protected void setTarget(S target) {
        this.target = target;
    }

    protected void setState(S state) {
        this.state = state;
    }

    protected void setEvent(E event) {
        this.event = event;
    }

    protected void setPeriod(long period) {
        this.period = period;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    protected void addAction(Action<S, E> action) {
        this.addAction(action, null);
    }

    protected void addAction(Action<S, E> action, Action<S, E> error) {
        this.actions.add(error != null ? Actions.errorCallingAction(action, error) : action);
    }

    protected void setGuard(Guard<S, E> guard) {
        this.guard = guard;
    }

    protected void setSecurityRule(String attributes, SecurityRule.ComparisonType match) {
        if (this.securityRule == null) {
            this.securityRule = new SecurityRule();
        }
        this.securityRule.setAttributes(SecurityRule.commaDelimitedListToSecurityAttributes(attributes));
    }

    protected void setSecurityRule(String expression) {
        if (this.securityRule == null) {
            this.securityRule = new SecurityRule();
        }
        this.securityRule.setExpression(expression);
    }
}

