/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.VerifierConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.verifier.CompositeStateMachineModelVerifier;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;

public class DefaultVerifierConfigurer<S, E>
extends AnnotationConfigurerAdapter<ConfigurationData<S, E>, StateMachineConfigurationConfigurer<S, E>, StateMachineConfigurationBuilder<S, E>>
implements VerifierConfigurer<S, E> {
    private boolean enabled = true;
    private StateMachineModelVerifier<S, E> verifier;

    @Override
    public void configure(StateMachineConfigurationBuilder<S, E> builder) throws Exception {
        builder.setVerifierEnabled(this.enabled);
        if (this.verifier != null) {
            builder.setVerifier(this.verifier);
        } else {
            builder.setVerifier(new CompositeStateMachineModelVerifier());
        }
    }

    @Override
    public VerifierConfigurer<S, E> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public VerifierConfigurer<S, E> verifier(StateMachineModelVerifier<S, E> verifier) {
        this.verifier = verifier;
        return this;
    }
}

