/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.event;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.event.OnEventNotAcceptedEvent;
import org.springframework.statemachine.event.OnExtendedStateChanged;
import org.springframework.statemachine.event.OnStateChangedEvent;
import org.springframework.statemachine.event.OnStateEntryEvent;
import org.springframework.statemachine.event.OnStateExitEvent;
import org.springframework.statemachine.event.OnStateMachineError;
import org.springframework.statemachine.event.OnStateMachineStart;
import org.springframework.statemachine.event.OnStateMachineStop;
import org.springframework.statemachine.event.OnTransitionEndEvent;
import org.springframework.statemachine.event.OnTransitionEvent;
import org.springframework.statemachine.event.OnTransitionStartEvent;
import org.springframework.statemachine.event.StateMachineEventPublisher;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;

public class DefaultStateMachineEventPublisher
implements StateMachineEventPublisher,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public DefaultStateMachineEventPublisher() {
    }

    public DefaultStateMachineEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void publishStateChanged(Object source, State<?, ?> sourceState, State<?, ?> targetState) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateChangedEvent(source, sourceState, targetState));
        }
    }

    @Override
    public void publishStateEntered(Object source, State<?, ?> state) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateEntryEvent(source, state));
        }
    }

    @Override
    public void publishStateExited(Object source, State<?, ?> state) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateExitEvent(source, state));
        }
    }

    @Override
    public void publishEventNotAccepted(Object source, Message<?> event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnEventNotAcceptedEvent(source, event));
        }
    }

    @Override
    public void publishTransitionStart(Object source, Transition<?, ?> transition) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnTransitionStartEvent(source, transition));
        }
    }

    @Override
    public void publishTransitionEnd(Object source, Transition<?, ?> transition) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnTransitionEndEvent(source, transition));
        }
    }

    @Override
    public void publishTransition(Object source, Transition<?, ?> transition) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnTransitionEvent(source, transition));
        }
    }

    @Override
    public void publishStateMachineStart(Object source, StateMachine<?, ?> stateMachine) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateMachineStart(source, stateMachine));
        }
    }

    @Override
    public void publishStateMachineStop(Object source, StateMachine<?, ?> stateMachine) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateMachineStop(source, stateMachine));
        }
    }

    @Override
    public void publishStateMachineError(Object source, StateMachine<?, ?> stateMachine, Exception exception) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnStateMachineError(source, stateMachine, exception));
        }
    }

    @Override
    public void publishExtendedStateChanged(Object source, Object key, Object value) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new OnExtendedStateChanged(source, key, value));
        }
    }
}

