/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.action.CompositeActionListener;
import org.springframework.statemachine.action.StateDoActionPolicy;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.CompositeStateListener;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateListener;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.trigger.Trigger;

public abstract class AbstractState<S, E>
extends LifecycleObjectSupport
implements State<S, E> {
    private static final Log log = LogFactory.getLog(AbstractState.class);
    private final S id;
    private final PseudoState<S, E> pseudoState;
    private final Collection<E> deferred;
    private final Collection<? extends Action<S, E>> entryActions;
    private final Collection<? extends Action<S, E>> exitActions;
    private final Collection<? extends Action<S, E>> stateActions;
    private final Collection<Region<S, E>> regions = new ArrayList<Region<S, E>>();
    private final StateMachine<S, E> submachine;
    private List<Trigger<S, E>> triggers = new ArrayList<Trigger<S, E>>();
    private final CompositeStateListener<S, E> stateListener = new CompositeStateListener();
    private final List<ScheduledAction> scheduledActions = new ArrayList<ScheduledAction>();
    private CompositeActionListener<S, E> actionListener;
    private final List<StateMachineListener<S, E>> completionListeners = new CopyOnWriteArrayList<StateMachineListener<S, E>>();
    private StateDoActionPolicy stateDoActionPolicy;
    private Long stateDoActionPolicyTimeout;

    public AbstractState(S id, PseudoState<S, E> pseudoState) {
        this(id, null, null, null, pseudoState);
    }

    public AbstractState(S id, Collection<E> deferred) {
        this(id, deferred, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        this(id, deferred, entryActions, exitActions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions) {
        this(id, deferred, entryActions, exitActions, pseudoState, regions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, null, pseudoState, regions, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, Collection<? extends Action<S, E>> stateActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this.id = id;
        this.deferred = deferred != null ? deferred : Collections.emptySet();
        this.entryActions = entryActions != null ? entryActions : Collections.emptySet();
        this.exitActions = exitActions != null ? exitActions : Collections.emptySet();
        this.stateActions = stateActions != null ? stateActions : Collections.emptySet();
        this.pseudoState = pseudoState;
        if (regions != null) {
            this.regions.addAll(regions);
        }
        this.submachine = submachine;
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        return false;
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        return this.deferred.contains(event.getPayload());
    }

    @Override
    public void exit(StateContext<S, E> context) {
        if (this.submachine != null) {
            for (StateMachineListener<S, E> l : this.completionListeners) {
                this.submachine.removeStateListener(l);
            }
        } else if (!this.regions.isEmpty()) {
            for (Region<S, E> region : this.regions) {
                for (StateMachineListener<S, E> l : this.completionListeners) {
                    region.removeStateListener(l);
                }
            }
        }
        this.completionListeners.clear();
        this.cancelStateActions();
        this.stateListener.onExit(context);
        this.disarmTriggers();
    }

    @Override
    public void entry(StateContext<S, E> context) {
        if (this.submachine != null) {
            StateMachineListenerAdapter l = new StateMachineListenerAdapter<S, E>(){

                @Override
                public void stateContext(StateContext<S, E> stateContext) {
                    if (stateContext.getStage() == StateContext.Stage.STATEMACHINE_STOP && stateContext.getStateMachine() == AbstractState.this.submachine && AbstractState.this.submachine.isComplete()) {
                        AbstractState.this.completionListeners.remove(this);
                        AbstractState.this.submachine.removeStateListener(this);
                        if (AbstractState.this.completionListeners.isEmpty()) {
                            AbstractState.this.notifyStateOnComplete(stateContext);
                        }
                    }
                }
            };
            this.submachine.addStateListener(l);
        } else if (!this.regions.isEmpty()) {
            for (final Region<S, E> region : this.regions) {
                StateMachineListenerAdapter l = new StateMachineListenerAdapter<S, E>(){

                    @Override
                    public void stateContext(StateContext<S, E> stateContext) {
                        if (stateContext.getStage() == StateContext.Stage.STATEMACHINE_STOP && stateContext.getStateMachine() == region && region.isComplete()) {
                            AbstractState.this.completionListeners.remove(this);
                            region.removeStateListener(this);
                            if (AbstractState.this.completionListeners.isEmpty()) {
                                AbstractState.this.notifyStateOnComplete(stateContext);
                            }
                        }
                    }
                };
                this.completionListeners.add(l);
                region.addStateListener(l);
            }
        }
        this.stateListener.onEntry(context);
        this.armTriggers();
        this.scheduleStateActions(context);
    }

    @Override
    public S getId() {
        return this.id;
    }

    @Override
    public abstract Collection<S> getIds();

    @Override
    public abstract Collection<State<S, E>> getStates();

    @Override
    public PseudoState<S, E> getPseudoState() {
        return this.pseudoState;
    }

    @Override
    public Collection<E> getDeferredEvents() {
        return this.deferred;
    }

    @Override
    public Collection<? extends Action<S, E>> getEntryActions() {
        return this.entryActions;
    }

    @Override
    public Collection<? extends Action<S, E>> getStateActions() {
        return this.stateActions;
    }

    @Override
    public Collection<? extends Action<S, E>> getExitActions() {
        return this.exitActions;
    }

    @Override
    public boolean isComposite() {
        return !this.regions.isEmpty();
    }

    @Override
    public boolean isOrthogonal() {
        return this.regions.size() > 1;
    }

    @Override
    public boolean isSimple() {
        return !this.isSubmachineState() && !this.isComposite();
    }

    @Override
    public boolean isSubmachineState() {
        return this.submachine != null;
    }

    @Override
    public void addStateListener(StateListener<S, E> listener) {
        this.stateListener.register(listener);
    }

    @Override
    public void removeStateListener(StateListener<S, E> listener) {
        this.stateListener.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener == null) {
                this.actionListener = new CompositeActionListener();
            }
            this.actionListener.register(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener != null) {
                this.actionListener.unregister(listener);
            }
        }
    }

    @Override
    protected void doStart() {
        this.armTriggers();
    }

    @Override
    protected void doStop() {
        this.disarmTriggers();
    }

    public StateMachine<S, E> getSubmachine() {
        return this.submachine;
    }

    public Collection<Region<S, E>> getRegions() {
        return this.regions;
    }

    public void setTriggers(List<Trigger<S, E>> triggers) {
        if (triggers != null) {
            this.triggers = triggers;
        } else {
            this.triggers.clear();
        }
    }

    public List<Trigger<S, E>> getTriggers() {
        return this.triggers;
    }

    public void setStateDoActionPolicy(StateDoActionPolicy stateDoActionPolicy) {
        this.stateDoActionPolicy = stateDoActionPolicy;
    }

    public void setStateDoActionPolicyTimeout(Long stateDoActionPolicyTimeout) {
        this.stateDoActionPolicyTimeout = stateDoActionPolicyTimeout;
    }

    protected void armTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.arm();
        }
    }

    protected void disarmTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.disarm();
        }
    }

    protected void cancelStateActions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling finish of state actions, scheduledActions size is " + this.scheduledActions.size()));
        }
        for (ScheduledAction task : this.scheduledActions) {
            if (task.timeout != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Timeouting scheduled state do action " + task));
                }
                try {
                    task.future.get(task.timeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cancelling scheduled state do action after timeout " + task));
                    }
                    task.future.cancel(true);
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cancelling scheduled state do action immediately " + task));
            }
            task.future.cancel(true);
        }
        this.scheduledActions.clear();
    }

    protected void scheduleStateActions(StateContext<S, E> context) {
        AtomicInteger completionCount = null;
        if (this.isSimple()) {
            completionCount = new AtomicInteger(this.stateActions.size());
        }
        for (Action<S, E> action : this.stateActions) {
            ScheduledFuture<?> future = this.scheduleAction(action, context, completionCount);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduling state do action " + action + " with future " + future));
            }
            if (future == null) continue;
            this.scheduledActions.add(new ScheduledAction(future, this.resolveDoActionTimeout(context)));
        }
        if (this.isSimple() && this.stateActions.size() == 0) {
            this.notifyStateOnComplete(context);
        }
    }

    protected void executeAction(Action<S, E> action, StateContext<S, E> context) {
        long now = System.currentTimeMillis();
        action.execute(context);
        if (this.actionListener != null) {
            try {
                this.actionListener.onExecute(context.getStateMachine(), action, System.currentTimeMillis() - now);
            }
            catch (Exception e) {
                log.warn((Object)"Error with actionListener", (Throwable)e);
            }
        }
    }

    protected ScheduledFuture<?> scheduleAction(final Action<S, E> action, final StateContext<S, E> context, final AtomicInteger completionCount) {
        TaskScheduler taskScheduler = this.getTaskScheduler();
        if (taskScheduler == null) {
            log.error((Object)("Unable to schedule action as taskSchedule is not set, action=[" + action + "]"));
            return null;
        }
        ScheduledFuture future = taskScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractState.this.executeAction(action, context);
                if (completionCount != null && completionCount.decrementAndGet() <= 0) {
                    AbstractState.this.notifyStateOnComplete(context);
                }
            }
        }, new Date());
        return future;
    }

    protected void notifyStateOnComplete(StateContext<S, E> context) {
        this.stateListener.onComplete(context);
    }

    private Long resolveDoActionTimeout(StateContext<S, E> context) {
        Long timeout = null;
        if (this.stateDoActionPolicy == StateDoActionPolicy.TIMEOUT_CANCEL && (timeout = StateMachineUtils.getMessageHeaderDoActionTimeout(context)) == null) {
            timeout = this.stateDoActionPolicyTimeout;
        }
        return timeout;
    }

    public String toString() {
        return "AbstractState [id=" + this.id + ", pseudoState=" + this.pseudoState + ", deferred=" + this.deferred + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", stateActions=" + this.stateActions + ", regions=" + this.regions + ", submachine=" + this.submachine + "]";
    }

    private static class ScheduledAction {
        ScheduledFuture<?> future;
        Long timeout;

        public ScheduledAction(ScheduledFuture<?> future, Long timeout) {
            this.future = future;
            this.timeout = timeout;
        }

        public String toString() {
            return "ScheduledTask [future=" + this.future + ", timeout=" + this.timeout + "]";
        }
    }
}

