/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.state.AbstractPseudoState;
import org.springframework.statemachine.state.DefaultPseudoStateContext;
import org.springframework.statemachine.state.PseudoStateContext;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateHolder;
import org.springframework.statemachine.state.StateListenerAdapter;
import org.springframework.util.Assert;

public class JoinPseudoState<S, E>
extends AbstractPseudoState<S, E> {
    private static final Log log = LogFactory.getLog(JoinPseudoState.class);
    private final List<State<S, E>> joins;
    private final JoinTracker tracker;
    private final List<JoinStateData<S, E>> joinTargets;

    public JoinPseudoState(List<State<S, E>> joins, List<JoinStateData<S, E>> joinTargets) {
        super(PseudoStateKind.JOIN);
        this.joins = joins;
        this.joinTargets = joinTargets;
        this.tracker = new JoinTracker();
    }

    @Override
    public State<S, E> entry(StateContext<S, E> context) {
        if (!this.tracker.isNotified()) {
            return null;
        }
        State<S, E> s = null;
        for (JoinStateData<S, E> c : this.joinTargets) {
            s = c.getState();
            if (((JoinStateData)c).guard == null || !this.evaluateInternal(((JoinStateData)c).guard, context)) continue;
            break;
        }
        return s;
    }

    @Override
    public void exit(StateContext<S, E> context) {
        this.tracker.reset();
    }

    public List<State<S, E>> getJoins() {
        return this.joins;
    }

    public void reset(Collection<S> ids) {
        this.tracker.reset(ids);
    }

    private boolean evaluateInternal(Guard<S, E> guard, StateContext<S, E> context) {
        try {
            return guard.evaluate(context);
        }
        catch (Throwable t) {
            log.warn((Object)"Deny guard due to throw as GUARD should not error", t);
            return false;
        }
    }

    public static class JoinStateData<S, E> {
        private final StateHolder<S, E> state;
        private final Guard<S, E> guard;

        public JoinStateData(StateHolder<S, E> state, Guard<S, E> guard) {
            Assert.notNull(state, (String)"Holder must be set");
            this.state = state;
            this.guard = guard;
        }

        public StateHolder<S, E> getStateHolder() {
            return this.state;
        }

        public State<S, E> getState() {
            return this.state.getState();
        }

        public Guard<S, E> getGuard() {
            return this.guard;
        }
    }

    private class JoinTracker {
        private final List<State<S, E>> track;
        private volatile boolean notified = false;

        public JoinTracker() {
            this.track = new ArrayList(JoinPseudoState.this.joins);
            Iterator iterator = JoinPseudoState.this.joins.iterator();
            while (iterator.hasNext()) {
                State tt;
                final State t = tt = (State)iterator.next();
                t.addStateListener(new StateListenerAdapter<S, E>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete(StateContext<S, E> context) {
                        boolean trackSizeZero = false;
                        List list = JoinTracker.this.track;
                        synchronized (list) {
                            JoinTracker.this.track.remove(t);
                            if (JoinTracker.this.track.size() == 0) {
                                trackSizeZero = true;
                            }
                        }
                        if (!JoinTracker.this.notified && trackSizeZero) {
                            log.debug((Object)"Join complete");
                            JoinTracker.this.notified = true;
                            JoinPseudoState.this.notifyContext(new DefaultPseudoStateContext(JoinPseudoState.this, PseudoStateContext.PseudoAction.JOIN_COMPLETED));
                        }
                    }
                });
            }
        }

        void reset() {
            this.track.clear();
            this.track.addAll(JoinPseudoState.this.joins);
            this.notified = false;
        }

        void reset(Collection<S> ids) {
            this.track.clear();
            for (State j : JoinPseudoState.this.joins) {
                if (ids.contains(j.getId())) continue;
                this.track.add(j);
            }
            this.notified = false;
        }

        public boolean isNotified() {
            return this.notified;
        }
    }
}

