/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.state.JoinPseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateContext;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineExecutor;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorList;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.support.TransitionComparator;
import org.springframework.statemachine.transition.AbstractTransition;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionConflictPolicy;
import org.springframework.statemachine.trigger.DefaultTriggerContext;
import org.springframework.statemachine.trigger.TimerTrigger;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.statemachine.trigger.TriggerListener;

public class DefaultStateMachineExecutor<S, E>
extends LifecycleObjectSupport
implements StateMachineExecutor<S, E> {
    private static final Log log = LogFactory.getLog(DefaultStateMachineExecutor.class);
    private final StateMachine<S, E> stateMachine;
    private final StateMachine<S, E> relayStateMachine;
    private final Queue<Message<E>> eventQueue = new ConcurrentLinkedQueue<Message<E>>();
    private final LinkedList<Message<E>> deferList = new LinkedList();
    private final Queue<TriggerQueueItem> triggerQueue = new ConcurrentLinkedQueue<TriggerQueueItem>();
    private final Collection<Transition<S, E>> transitions;
    private final AtomicBoolean requestTask = new AtomicBoolean(false);
    private final Map<Trigger<S, E>, Transition<S, E>> triggerToTransitionMap;
    private final List<Transition<S, E>> triggerlessTransitions;
    private final Transition<S, E> initialTransition;
    private final Message<E> initialEvent;
    private final AtomicBoolean initialHandled = new AtomicBoolean(false);
    private final AtomicReference<Runnable> taskRef = new AtomicReference();
    private StateMachineExecutor.StateMachineExecutorTransit<S, E> stateMachineExecutorTransit;
    private final StateMachineInterceptorList<S, E> interceptors = new StateMachineInterceptorList();
    private volatile Message<E> forwardedInitialEvent;
    private volatile Message<E> queuedMessage = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final TransitionComparator<S, E> transitionComparator;
    private final TransitionConflictPolicy transitionConflictPolicy;
    private final Set<Transition<S, E>> joinSyncTransitions = new HashSet<Transition<S, E>>();
    private final Set<State<S, E>> joinSyncStates = new HashSet<State<S, E>>();

    public DefaultStateMachineExecutor(StateMachine<S, E> stateMachine, StateMachine<S, E> relayStateMachine, Collection<Transition<S, E>> transitions, Map<Trigger<S, E>, Transition<S, E>> triggerToTransitionMap, List<Transition<S, E>> triggerlessTransitions, Transition<S, E> initialTransition, Message<E> initialEvent, TransitionConflictPolicy transitionConflictPolicy) {
        this.stateMachine = stateMachine;
        this.relayStateMachine = relayStateMachine;
        this.triggerToTransitionMap = triggerToTransitionMap;
        this.triggerlessTransitions = triggerlessTransitions;
        this.transitions = transitions;
        this.initialTransition = initialTransition;
        this.initialEvent = initialEvent;
        this.transitionComparator = new TransitionComparator(transitionConflictPolicy);
        this.transitionConflictPolicy = transitionConflictPolicy;
        this.triggerlessTransitions.sort(this.transitionComparator);
        this.registerTriggerListener();
    }

    @Override
    public void queueEvent(Message<E> message) {
        this.eventQueue.add(message);
    }

    @Override
    public void queueTrigger(Trigger<S, E> trigger, Message<E> message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queue trigger " + trigger));
        }
        this.triggerQueue.add(new TriggerQueueItem(trigger, message));
    }

    @Override
    public void queueDeferredEvent(Message<E> message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deferring message " + message));
        }
        this.deferList.addLast(message);
    }

    @Override
    public void execute() {
        this.scheduleEventQueueProcessing();
    }

    @Override
    public void setStateMachineExecutorTransit(StateMachineExecutor.StateMachineExecutorTransit<S, E> stateMachineExecutorTransit) {
        this.stateMachineExecutorTransit = stateMachineExecutorTransit;
    }

    @Override
    protected void doStart() {
        super.doStart();
        this.startTriggers();
        this.execute();
    }

    @Override
    protected void doStop() {
        this.stopTriggers();
        super.doStop();
        this.initialHandled.set(false);
    }

    @Override
    public void setInitialEnabled(boolean enabled) {
        this.initialHandled.set(!enabled);
    }

    @Override
    public void setForwardedInitialEvent(Message<E> message) {
        this.forwardedInitialEvent = message;
    }

    @Override
    public void addStateMachineInterceptor(StateMachineInterceptor<S, E> interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    private boolean handleTriggerTrans(List<Transition<S, E>> trans, Message<E> queuedMessage) {
        return this.handleTriggerTrans(trans, queuedMessage, null);
    }

    private boolean handleTriggerTrans(List<Transition<S, E>> trans, Message<E> queuedMessage, State<S, E> completion) {
        boolean transit = false;
        for (Transition<S, E> t : trans) {
            State currentState;
            State<S, E> source;
            if (t == null || (source = t.getSource()) == null || (currentState = this.stateMachine.getState()) == null || !StateMachineUtils.containsAtleastOne(source.getIds(), currentState.getIds()) || this.transitionConflictPolicy != TransitionConflictPolicy.PARENT && completion != null && !source.getId().equals(completion.getId()) && (source.isOrthogonal() || !StateMachineUtils.isSubstate(source, completion))) continue;
            if (StateMachineUtils.isPseudoState(t.getTarget(), PseudoStateKind.JOIN)) {
                if (this.joinSyncStates.isEmpty()) {
                    List joins = ((JoinPseudoState)t.getTarget().getPseudoState()).getJoins();
                    this.joinSyncStates.addAll(joins);
                }
                this.joinSyncTransitions.add(t);
                boolean removed = this.joinSyncStates.remove(t.getSource());
                boolean joincomplete = removed & this.joinSyncStates.isEmpty();
                if (!joincomplete) continue;
                for (Transition<S, E> tt : this.joinSyncTransitions) {
                    StateContext<S, E> stateContext = this.buildStateContext(queuedMessage, tt, this.relayStateMachine);
                    tt.transit(stateContext);
                    this.stateMachineExecutorTransit.transit(tt, stateContext, queuedMessage);
                }
                this.joinSyncTransitions.clear();
                break;
            }
            StateContext<S, E> stateContext = this.buildStateContext(queuedMessage, t, this.relayStateMachine);
            try {
                stateContext = this.interceptors.preTransition(stateContext);
            }
            catch (Exception e) {
                log.info((Object)"Interceptors threw exception", (Throwable)e);
                stateContext = null;
            }
            if (stateContext == null) break;
            try {
                transit = t.transit(stateContext);
            }
            catch (Exception e) {
                log.warn((Object)("Aborting as transition " + t), (Throwable)e);
            }
            if (!transit) continue;
            try {
                this.stateMachineExecutorTransit.transit(t, stateContext, queuedMessage);
            }
            catch (Exception e) {
                this.interceptors.postTransition(stateContext);
                return false;
            }
            this.interceptors.postTransition(stateContext);
            break;
        }
        return transit;
    }

    private void handleInitialTrans(Transition<S, E> tran, Message<E> queuedMessage) {
        StateContext<S, E> stateContext = this.buildStateContext(queuedMessage, tran, this.relayStateMachine);
        tran.transit(stateContext);
        this.stateMachineExecutorTransit.transit(tran, stateContext, queuedMessage);
    }

    private void scheduleEventQueueProcessing() {
        TaskExecutor executor = this.getTaskExecutor();
        if (executor == null) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                DefaultStateMachineExecutor.this.lock.lock();
                try {
                    boolean eventProcessed = false;
                    while (DefaultStateMachineExecutor.this.processEventQueue()) {
                        eventProcessed = true;
                        DefaultStateMachineExecutor.this.processTriggerQueue();
                        while (DefaultStateMachineExecutor.this.processDeferList()) {
                            DefaultStateMachineExecutor.this.processTriggerQueue();
                        }
                    }
                    if (!eventProcessed) {
                        DefaultStateMachineExecutor.this.processTriggerQueue();
                        while (DefaultStateMachineExecutor.this.processDeferList()) {
                            DefaultStateMachineExecutor.this.processTriggerQueue();
                        }
                    }
                    if (DefaultStateMachineExecutor.this.requestTask.getAndSet(false)) {
                        DefaultStateMachineExecutor.this.scheduleEventQueueProcessing();
                    }
                    DefaultStateMachineExecutor.this.taskRef.set(null);
                }
                finally {
                    DefaultStateMachineExecutor.this.lock.unlock();
                }
                if (DefaultStateMachineExecutor.this.requestTask.getAndSet(false)) {
                    DefaultStateMachineExecutor.this.scheduleEventQueueProcessing();
                }
            }
        };
        if (this.taskRef.compareAndSet(null, task)) {
            executor.execute(task);
        } else {
            this.requestTask.set(true);
        }
    }

    private boolean processEventQueue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process event queue, size=" + this.eventQueue.size()));
        }
        Message<E> queuedEvent = this.eventQueue.poll();
        State currentState = this.stateMachine.getState();
        if (queuedEvent != null) {
            if (currentState != null && currentState.shouldDefer(queuedEvent)) {
                log.info((Object)("Current state " + currentState + " deferred event " + queuedEvent));
                this.queueDeferredEvent(queuedEvent);
                return true;
            }
            for (Transition<S, E> transition : this.transitions) {
                State<S, E> source = transition.getSource();
                Trigger trigger = transition.getTrigger();
                if (!StateMachineUtils.containsAtleastOne(source.getIds(), currentState.getIds()) || trigger == null || !trigger.evaluate(new DefaultTriggerContext(queuedEvent.getPayload()))) continue;
                this.queueTrigger(trigger, queuedEvent);
                return true;
            }
            return true;
        }
        return false;
    }

    private void processTriggerQueue() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.initialHandled.getAndSet(true)) {
            ArrayList<Transition<S, E>> trans = new ArrayList<Transition<S, E>>();
            trans.add(this.initialTransition);
            if (this.initialEvent != null) {
                this.handleInitialTrans(this.initialTransition, this.initialEvent);
            } else {
                this.handleInitialTrans(this.initialTransition, this.forwardedInitialEvent);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process trigger queue, size=" + this.triggerQueue.size() + " " + this));
        }
        TriggerQueueItem queueItem = this.triggerQueue.poll();
        State currentState = this.stateMachine.getState();
        if (queueItem != null && currentState != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Process trigger item " + queueItem + " " + this));
            }
            this.queuedMessage = queueItem.message;
            Object event = this.queuedMessage != null ? this.queuedMessage.getPayload() : null;
            ArrayList trans = new ArrayList();
            if (event != null) {
                ArrayList ids = new ArrayList(currentState.getIds());
                Collections.reverse(ids);
                for (Object id : ids) {
                    for (Map.Entry<Trigger<S, E>, Transition<S, E>> e : this.triggerToTransitionMap.entrySet()) {
                        Trigger<S, E> tri = e.getKey();
                        E ee = tri.getEvent();
                        Transition<S, E> tra = e.getValue();
                        if (!event.equals(ee) || !tra.getSource().getId().equals(id) || trans.contains(tra)) continue;
                        trans.add(tra);
                    }
                }
            }
            if (trans.isEmpty()) {
                trans.add(this.triggerToTransitionMap.get(queueItem.trigger));
            }
            trans.sort(this.transitionComparator);
            this.handleTriggerTrans(trans, this.queuedMessage);
        }
        ArrayList<Transition<S, Transition<S, E>>> transWithGuards = new ArrayList<Transition<S, Transition<S, E>>>();
        for (Transition<S, E> t : this.triggerlessTransitions) {
            if (((AbstractTransition)t).getGuard() == null) continue;
            transWithGuards.add(t);
        }
        if (this.stateMachine.getState() != null) {
            boolean transit = false;
            while (transit = this.handleTriggerTrans(transWithGuards, this.queuedMessage)) {
            }
        }
    }

    @Override
    public void executeTriggerlessTransitions(StateContext<S, E> context, State<S, E> state) {
        if (this.stateMachine.getState() != null) {
            this.handleTriggerTrans(this.triggerlessTransitions, context.getMessage(), state);
        }
    }

    private synchronized boolean processDeferList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process defer list, size=" + this.deferList.size()));
        }
        ListIterator iterator = this.deferList.listIterator();
        State currentState = this.stateMachine.getState();
        while (iterator.hasNext()) {
            Message event = (Message)iterator.next();
            if (currentState.shouldDefer(event)) continue;
            for (Transition<S, E> transition : this.transitions) {
                State<S, E> source = transition.getSource();
                Trigger trigger = transition.getTrigger();
                if (!source.equals(currentState) || trigger == null || !trigger.evaluate(new DefaultTriggerContext(event.getPayload()))) continue;
                this.triggerQueue.add(new TriggerQueueItem(trigger, event));
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private StateContext<S, E> buildStateContext(Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
        MessageHeaders messageHeaders = message != null ? message.getHeaders() : new MessageHeaders(new HashMap());
        HashMap<String, UUID> map = new HashMap<String, UUID>((Map<String, UUID>)messageHeaders);
        if (!map.containsKey("_sm_id_")) {
            map.put("_sm_id_", stateMachine.getUuid());
        }
        return new DefaultStateContext<S, E>(StateContext.Stage.TRANSITION, message, new MessageHeaders(map), stateMachine.getExtendedState(), transition, stateMachine, null, null, null);
    }

    private void registerTriggerListener() {
        for (final Trigger<S, E> trigger : this.triggerToTransitionMap.keySet()) {
            if (!(trigger instanceof TimerTrigger)) continue;
            ((TimerTrigger)trigger).addTriggerListener(new TriggerListener(){

                @Override
                public void triggered() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TimedTrigger triggered " + trigger));
                    }
                    DefaultStateMachineExecutor.this.triggerQueue.add(new TriggerQueueItem(trigger, null));
                    if (DefaultStateMachineExecutor.this.isRunning()) {
                        DefaultStateMachineExecutor.this.scheduleEventQueueProcessing();
                    }
                }
            });
        }
    }

    private void startTriggers() {
        for (Trigger<S, E> trigger : this.triggerToTransitionMap.keySet()) {
            if (!(trigger instanceof Lifecycle)) continue;
            ((Lifecycle)trigger).start();
        }
    }

    private void stopTriggers() {
        for (Trigger<S, E> trigger : this.triggerToTransitionMap.keySet()) {
            if (!(trigger instanceof Lifecycle)) continue;
            ((Lifecycle)trigger).stop();
        }
    }

    private class TriggerQueueItem {
        Trigger<S, E> trigger;
        Message<E> message;

        public TriggerQueueItem(Trigger<S, E> trigger, Message<E> message) {
            this.trigger = trigger;
            this.message = message;
        }
    }
}

