/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class ObservableMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> delegate;
    private volatile MapChangeListener<K, V> listener;

    public ObservableMap() {
        this.delegate = new ConcurrentHashMap();
    }

    public ObservableMap(Map<K, V> map, MapChangeListener<K, V> listener) {
        Assert.notNull(map, (String)"Delegating map must be set");
        Assert.notNull(listener, (String)"Listener must be set");
        this.delegate = map;
        this.listener = listener;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        V put = this.delegate.put(key, value);
        if (this.listener != null) {
            if (put == null) {
                this.listener.added(key, value);
            } else if (value != null && !value.equals(put)) {
                this.listener.changed(key, value);
            }
        }
        return put;
    }

    @Override
    public V remove(Object key) {
        V remove = this.delegate.remove(key);
        if (this.listener != null && remove != null) {
            this.listener.removed(key, remove);
        }
        return remove;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Map<K, V> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    public void setListener(MapChangeListener<K, V> listener) {
        this.listener = listener;
    }

    public static interface MapChangeListener<K, V> {
        public void added(K var1, V var2);

        public void changed(K var1, V var2);

        public void removed(K var1, V var2);
    }
}

