/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.util.Assert;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    private T next;

    protected abstract T computeNext();

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Assert.state((this.state != State.FAILED ? 1 : 0) != 0, (String)"state cannot be null");
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    public final T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

