/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.transition;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.action.CompositeActionListener;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.util.Assert;

public abstract class AbstractTransition<S, E>
implements Transition<S, E> {
    private static final Log log = LogFactory.getLog(AbstractTransition.class);
    protected final State<S, E> target;
    protected final Collection<Action<S, E>> actions;
    private final State<S, E> source;
    private final TransitionKind kind;
    private final Guard<S, E> guard;
    private final Trigger<S, E> trigger;
    private final SecurityRule securityRule;
    private CompositeActionListener<S, E> actionListener;

    public AbstractTransition(State<S, E> source, State<S, E> target, Collection<Action<S, E>> actions, E event, TransitionKind kind, Guard<S, E> guard, Trigger<S, E> trigger) {
        this(source, target, actions, event, kind, guard, trigger, null);
    }

    public AbstractTransition(State<S, E> source, State<S, E> target, Collection<Action<S, E>> actions, E event, TransitionKind kind, Guard<S, E> guard, Trigger<S, E> trigger, SecurityRule securityRule) {
        Assert.notNull((Object)((Object)kind), (String)"Transition type must be set");
        this.source = source;
        this.target = target;
        this.actions = actions;
        this.kind = kind;
        this.guard = guard;
        this.trigger = trigger;
        this.securityRule = securityRule;
    }

    @Override
    public State<S, E> getSource() {
        return this.source;
    }

    @Override
    public Trigger<S, E> getTrigger() {
        return this.trigger;
    }

    @Override
    public boolean transit(StateContext<S, E> context) {
        if (this.guard != null) {
            try {
                if (!this.guard.evaluate(context)) {
                    return false;
                }
            }
            catch (Throwable t) {
                log.warn((Object)"Deny guard due to throw as GUARD should not error", t);
                return false;
            }
        }
        return true;
    }

    @Override
    public Guard<S, E> getGuard() {
        return this.guard;
    }

    @Override
    public TransitionKind getKind() {
        return this.kind;
    }

    @Override
    public SecurityRule getSecurityRule() {
        return this.securityRule;
    }

    @Override
    public State<S, E> getTarget() {
        return this.target;
    }

    @Override
    public Collection<Action<S, E>> getActions() {
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener<S, E> listener) {
        AbstractTransition abstractTransition = this;
        synchronized (abstractTransition) {
            if (this.actionListener == null) {
                this.actionListener = new CompositeActionListener();
            }
            this.actionListener.register(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener<S, E> listener) {
        AbstractTransition abstractTransition = this;
        synchronized (abstractTransition) {
            if (this.actionListener != null) {
                this.actionListener.unregister(listener);
            }
        }
    }

    @Override
    public final void executeTransitionActions(StateContext<S, E> context) {
        if (this.actions == null) {
            return;
        }
        for (Action<S, E> action : this.actions) {
            long now = System.currentTimeMillis();
            action.execute(context);
            if (this.actionListener == null) continue;
            this.actionListener.onExecute(context.getStateMachine(), action, System.currentTimeMillis() - now);
        }
    }

    public String toString() {
        return "AbstractTransition [source=" + this.source + ", target=" + this.target + ", kind=" + (Object)((Object)this.kind) + ", guard=" + this.guard + "]";
    }
}

