/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.trigger;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.statemachine.support.CountTrigger;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.trigger.CompositeTriggerListener;
import org.springframework.statemachine.trigger.Trigger;
import org.springframework.statemachine.trigger.TriggerContext;
import org.springframework.statemachine.trigger.TriggerListener;

public class TimerTrigger<S, E>
extends LifecycleObjectSupport
implements Trigger<S, E> {
    private final CompositeTriggerListener triggerListener = new CompositeTriggerListener();
    private final long period;
    private final int count;
    private volatile ScheduledFuture<?> scheduled;

    public TimerTrigger(long period) {
        this(period, 0);
    }

    public TimerTrigger(long period, int count) {
        this.period = period;
        this.count = count;
    }

    public long getPeriod() {
        return this.period;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean evaluate(TriggerContext<S, E> context) {
        return false;
    }

    @Override
    public void addTriggerListener(TriggerListener listener) {
        this.triggerListener.register(listener);
    }

    @Override
    public E getEvent() {
        return null;
    }

    @Override
    protected void doStart() {
        if (this.count > 0) {
            return;
        }
        this.schedule();
    }

    @Override
    protected void doStop() {
        this.cancel();
    }

    @Override
    public void arm() {
        if (this.scheduled != null) {
            return;
        }
        this.schedule();
    }

    @Override
    public void disarm() {
        if (this.count > 0) {
            this.cancel();
        }
    }

    private void schedule() {
        long initialDelay = this.count > 0 ? this.period : 0L;
        this.scheduled = this.getTaskScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                TimerTrigger.this.notifyTriggered();
            }
        }, (org.springframework.scheduling.Trigger)new CountTrigger(this.count, this.period, initialDelay, TimeUnit.MILLISECONDS));
    }

    private void notifyTriggered() {
        this.triggerListener.triggered();
    }

    private void cancel() {
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
        }
        this.scheduled = null;
    }
}

