/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.detectors;

import java.io.File;
import java.util.List;
import java.util.Optional;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.LinuxStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.detectors.OSXStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.detectors.WindowsStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageDeviceDetector {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorageDeviceDetector.class);
    private static AbstractStorageDeviceDetector instance;

    public static synchronized AbstractStorageDeviceDetector getInstance() {
        if (instance == null) {
            switch (OSUtils.getOsType()) {
                case WINDOWS: {
                    instance = new WindowsStorageDeviceDetector();
                    break;
                }
                case LINUX: {
                    instance = new LinuxStorageDeviceDetector();
                    break;
                }
                case MAC_OS: {
                    instance = new OSXStorageDeviceDetector();
                }
            }
        }
        return instance;
    }

    protected AbstractStorageDeviceDetector() {
    }

    public abstract List<USBStorageDevice> getStorageDevicesDevices();

    static Optional<USBStorageDevice> getUSBDevice(String rootPath) {
        return AbstractStorageDeviceDetector.getUSBDevice(rootPath, null, null, null);
    }

    static Optional<USBStorageDevice> getUSBDevice(String rootPath, String deviceName, String device, String uuid) {
        File root = new File(rootPath);
        if (!root.isDirectory()) {
            log.trace("Invalid root found: {}", (Object)root);
            return Optional.empty();
        }
        log.trace("Device found: {}", (Object)root.getPath());
        try {
            return Optional.of(new USBStorageDevice(root, deviceName, device, uuid));
        }
        catch (IllegalArgumentException e) {
            log.debug("Could not add Device: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }
}

