/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.unmounters;

import com.github.tuupertunut.powershelllibjava.PowerShell;
import com.github.tuupertunut.powershelllibjava.PowerShellExecutionException;
import java.io.IOException;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;

public class WindowsStorageDeviceUnmounter
extends AbstractStorageDeviceUnmounter {
    private static final String CMD_UNMOUNT_1 = "$ErrorActionPreference = 'SilentlyContinue'";
    private static final String CMD_UNMOUNT_2 = "(New-Object -comObject Shell.Application).Namespace(17).ParseName('X:').InvokeVerb('Eject')";

    @Override
    public void unmount(USBStorageDevice usbStorageDevice) throws IOException {
        try (PowerShell psSession = PowerShell.open();){
            psSession.executeCommands(new String[]{CMD_UNMOUNT_1, CMD_UNMOUNT_2.replace("X:", usbStorageDevice.getDevice())});
            Thread.sleep(1000L);
        }
        catch (PowerShellExecutionException | InterruptedException e) {
            throw new IOException(e);
        }
    }
}

